using System.Windows.Forms;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Extends conventional <see cref="DateTimePicker"/> by making it nullable (can contain no selected value). 
	/// </summary>
	internal class NullableDateTimePicker : DateTimePicker
	{
		private const string VoidFormat = " ";
		private string _dateTimeFormatCache;
		private DateTimePickerFormat _formatCache;
		private bool _disabled;

		/// <summary>
		/// Constructs an object.
		/// </summary>
		internal NullableDateTimePicker() : base() 
		{
			_disabled = false;
		}

		/// <summary>
		/// Clears value and disables the picker. 
		/// </summary>
		internal void ClearAndDisable()
		{
			Enabled = false;

			if( _disabled )
				return;

			_dateTimeFormatCache = CustomFormat;
			_formatCache = Format;

			CustomFormat = VoidFormat;
			Format = DateTimePickerFormat.Custom;			
			
			_disabled = true;
		}

		/// <summary>
		/// Displays value and enables the picker.
		/// </summary>
		internal void RestoreAndEnable()
		{
			Enabled = true;

			CustomFormat = (_formatCache == DateTimePickerFormat.Custom) ? _dateTimeFormatCache : null;
			Format = _formatCache;
						
			_disabled = false;
		}

	}
}
